/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.mrp2;

import com.google.common.base.Preconditions;
import cz.insophy.inplan.mrp.CustomerRequest;
import cz.insophy.inplan.mrp.SupplyRequest;
import cz.insophy.inplan.mrp2.CrDemand;
import cz.insophy.inplan.mrp2.ExtSupply;
import cz.insophy.inplan.mrp2.GorDemand;
import cz.insophy.inplan.mrp2.GorSupply;
import cz.insophy.inplan.mrp2.PrDdSortKey;
import cz.insophy.inplan.mrp2.SortKeyExtractor;
import cz.insophy.inplan.mrp2.SrSupply;
import cz.insophy.inplan.mrp2.SsDemand;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import javax.annotation.Nonnull;

public class PrDdSortKeyExtractor
implements SortKeyExtractor<PrDdSortKey> {
    protected static final int SR_PRIORITY = 1;
    protected static final int EXT_PRIORITY = Integer.MIN_VALUE;
    protected static final long EXT_DUE_DATE = Long.MIN_VALUE;
    protected static final int SS_PRIORITY = 10;
    protected static final long SS_DUE_DATE = Long.MAX_VALUE;

    @Override
    @Nonnull
    public PrDdSortKey extract(@Nonnull GorSupply gorSupply) {
        Preconditions.checkNotNull(gorSupply);
        GeneralizedOrderRequest gor = Preconditions.checkNotNull(gorSupply.getGor());
        return new PrDdSortKey(gor.getPriority(), gor.getDueDate(), gor.getId());
    }

    @Override
    @Nonnull
    public PrDdSortKey extract(@Nonnull SrSupply srSupply) {
        Preconditions.checkNotNull(srSupply);
        SupplyRequest sr = Preconditions.checkNotNull(srSupply.getSr());
        return new PrDdSortKey(1, sr.getTime(), sr.getId());
    }

    @Override
    @Nonnull
    public PrDdSortKey extract(@Nonnull ExtSupply extSupply) {
        Preconditions.checkNotNull(extSupply);
        return new PrDdSortKey(Integer.MIN_VALUE, Long.MIN_VALUE, extSupply.getMaterial().getName());
    }

    @Override
    @Nonnull
    public PrDdSortKey extract(@Nonnull CrDemand crDemand) {
        Preconditions.checkNotNull(crDemand);
        CustomerRequest cr = Preconditions.checkNotNull(crDemand.getCr());
        return new PrDdSortKey(cr.getPriority(), cr.getTime(), cr.getId());
    }

    @Override
    @Nonnull
    public PrDdSortKey extract(@Nonnull GorDemand gorDemand) {
        Preconditions.checkNotNull(gorDemand);
        GeneralizedOrderRequest gor = Preconditions.checkNotNull(gorDemand.getGor());
        return new PrDdSortKey(gor.getPriority(), gor.getDueDate(), gor.getId());
    }

    @Override
    @Nonnull
    public PrDdSortKey extract(@Nonnull SsDemand ssDemand) {
        Preconditions.checkNotNull(ssDemand);
        return new PrDdSortKey(10, Long.MAX_VALUE, ssDemand.getMaterial().getName());
    }
}

